package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.EmpresaAuditoraDao;
import com.ejie.ab04b.model.EmpresaAuditora;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0479s00ServiceImpl generated by UDA, 23-Jan-2017 10:12:45.
 * 
 * @author UDA
 */

@Service(value = "ab0479s00Service")
public class EmpresaAuditoraServiceImpl implements EmpresaAuditoraService {

	@Autowired()
	private EmpresaAuditoraDao ab0479s00Dao;

	/**
	 * Inserts a single row in the Ab0479s00 table.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  Ab0479s00
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @return the empresa auditora
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EmpresaAuditora add(EmpresaAuditora ab0479s00) {
		return this.ab0479s00Dao.add(ab0479s00);
	}

	/**
	 * Updates a single row in the Ab0479s00 table.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  Ab0479s00
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @return the empresa auditora
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EmpresaAuditora update(EmpresaAuditora ab0479s00) {
		return this.ab0479s00Dao.update(ab0479s00);
	}

	/**
	 * Finds a single row in the Ab0479s00 table.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  Ab0479s00
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @return the empresa auditora
	 */
	public EmpresaAuditora find(EmpresaAuditora ab0479s00) {
		return (EmpresaAuditora) this.ab0479s00Dao.find(ab0479s00);
	}

	/**
	 * Deletes a single row in the Ab0479s00 table.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EmpresaAuditora ab0479s00) {
		this.ab0479s00Dao.remove(ab0479s00);
	}

	/**
	 * Finds a list of rows in the Ab0479s00 table.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0479s00>
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<EmpresaAuditora> findAll(EmpresaAuditora ab0479s00, JQGridRequestDto jqGridRequestDto) {
		return (List<EmpresaAuditora>) this.ab0479s00Dao.findAll(ab0479s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0479s00 table using like.
	 * 
	 *  ab0479s00
	 *            Ab0479s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0479s00>
	 *
	 * @param ab0479s00 the ab 0479 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<EmpresaAuditora> findAllLike(EmpresaAuditora ab0479s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return (List<EmpresaAuditora>) this.ab0479s00Dao.findAllLike(ab0479s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0479s00 table.
	 * 
	 *  filterAb0479s00
	 *            Ab0479s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb0479s00 the filter ab 0479 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(EmpresaAuditora filterAb0479s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab0479s00Dao.removeMultiple(filterAb0479s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab0479s00 table.
	 * 
	 *  filterAb0479s00
	 *            Ab0479s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0479s00>
	 *
	 * @param filterAb0479s00 the filter ab 0479 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<EmpresaAuditora> filter(EmpresaAuditora filterAb0479s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<EmpresaAuditora> listaAb0479s00 = this.ab0479s00Dao.findAllLike(filterAb0479s00, jqGridRequestDto, false);
		Long recordNum = this.ab0479s00Dao
				.findAllLikeCount(filterAb0479s00 != null ? filterAb0479s00 : new EmpresaAuditora(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<EmpresaAuditora>> reorderSelection = this.ab0479s00Dao.reorderSelection(filterAb0479s00,
					jqGridRequestDto, startsWith);
			return new JQGridResponseDto<EmpresaAuditora>(jqGridRequestDto, recordNum, listaAb0479s00,
					reorderSelection);
		}
		return new JQGridResponseDto<EmpresaAuditora>(jqGridRequestDto, recordNum, listaAb0479s00);
	}

	/**
	 * Searches rows in the Ab0479s00 table.
	 * 
	 *  filterAb0479s00
	 *            Ab0479s00
	 *  searchAb0479s00
	 *            Ab0479s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0479s00>>
	 *
	 * @param filterAb0479s00 the filter ab 0479 s 00
	 * @param searchAb0479s00 the search ab 0479 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<EmpresaAuditora>> search(EmpresaAuditora filterAb0479s00, EmpresaAuditora searchAb0479s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0479s00Dao.search(filterAb0479s00, searchAb0479s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0479s00 table.
	 * 
	 *  filterAb0479s00
	 *            Ab0479s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0479s00 the filter ab 0479 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(EmpresaAuditora filterAb0479s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab0479s00Dao.reorderSelection(filterAb0479s00, jqGridRequestDto, startsWith);
	}

}
